#!/bin/sh

# Try to find a way for refreshing the TeX database.
# MikTeX uses initexmf whereas teTeX uses texhash.
# If we can't find either one, bail out doing nothing.

refreshcmd=""
IFS=:
for dir in $PATH; do
    if [ -x "$dir/initexmf" ]; then
	refreshcmd="initexmf -u"
	break
    fi
    if [ -x "$dir/texhash" ]; then
	refreshcmd="texhash"
	break
    fi
done

# Ascertain that we have kpsewhich, otherwise we terminate.

found="no"
for dir in $PATH; do
    if [ -x "$dir/kpsewhich" ]; then
	found="yes"
	break
    fi  
done 
IFS=
if [ "$found" = "no" ]; then
    exit
fi

oldsty=`kpsewhich dvipost.sty | tr -d '\r'`
if [ -n "$oldsty" ]; then
    rm -f "$oldsty"
    cp /usr/local/share/dvipost/dvipost.sty "$oldsty"
else
    destdir=`kpsewhich latex.ltx|tr -d '\r'|sed 's%/[^/]*/latex.ltx%%'`/dvipost
    test -d "$destdir" || mkdir "$destdir" || exit
    cp /usr/local/share/dvipost/dvipost.sty "$destdir"
fi
if [ -n "$refreshcmd" ]; then
    eval "$refreshcmd"
fi

