/*
 * Copyright © Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 2 or 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mir/time/steady_clock.h"
#include <algorithm>

mir::time::Timestamp mir::time::SteadyClock::now() const
{
    return clock.now();
}

mir::time::Duration
mir::time::SteadyClock::min_wait_until(Timestamp t) const
{
    return std::max(t - now(), Duration{0});
}
